import React, { FC } from 'react';
import cx from 'classnames';
import { BadgeProps } from './Badge.types';
import { getBadgeColor } from './Badge.utils';
import css from './Badge.module.css';

export const Badge: FC<BadgeProps> = (props) => {
  return (
    <p className={cx(css.Badge, props.className, { [css.Badge_withShadow]: props.shadow })}>
      <span data-testid="attach-item-badge-shadow" className={css.Badge_shadow} />
      <span
        data-testid="attach-item-badge-text"
        className={css.Badge_text}
        style={{ backgroundColor: getBadgeColor(props.extension) }}
      >
        {props.extension}
      </span>
    </p>
  );
};
