import React, { FC } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import { DeleteProps } from './Delete.types';
import css from './Delete.module.css';

export const Delete: FC<DeleteProps> = (props) => {
  return (
    <button
      data-testid="attach-item-delete-button"
      onClick={(event) => {
        event.stopPropagation();
        props.onDelete(event);
      }}
      className={cx(css.Delete, props.className)}
      type="button"
    >
      <Icon svg="clear" />
    </button>
  );
};
