import React, { FC } from 'react';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import { DownloadProps } from './Download.types';
import css from './Download.module.css';

export const Download: FC<DownloadProps> = (props) => (
  <a
    data-testid="attach-item-download-link"
    href={props.downloadUrl}
    className={cx(css.Download, props.className)}
    target="_blank"
    onClick={(event) => event.stopPropagation()}
  >
    <Icon svg="download" />
  </a>
);
