import React from 'react';
import { AttachmentListStatelessProps, AttachmentListStatefulProps } from './AttachmentList.types';
import { AttachmentListStateless } from './AttachmentListStateless';
import { AttachmentListStateful } from './AttachmentListStateful';
import { getFileStubs } from './AttachmentList.stubs';

export default {
  title: 'AttachmentList',
  parameters: {
    backgrounds: {
      default: 'grey',
      values: [
        { name: 'grey', value: '#ccc' },
        { name: 'dark', value: '#333' },
      ],
    },
  },
  argTypes: {
    onFileClick: { action: 'clicked' },
    onFileDelete: { action: 'deleted' },
    onDownload: { action: 'download' },
  },
};

export const Limited = (args: AttachmentListStatelessProps & { filesCount: number }) => {
  const files = getFileStubs(args.filesCount);

  const onChange = () => {};

  return (
    <div style={{ width: '100%' }}>
      <AttachmentListStateless {...args} files={files} onHiddenItemsChange={onChange} />
    </div>
  );
};

export const Stateful = (args: AttachmentListStatefulProps & { filesCount: number }) => {
  const files = getFileStubs(args.filesCount);

  return <AttachmentListStateful {...args} files={files} />;
};

Limited.args = {
  filesCount: 10,
  isOpen: false,
};

Stateful.args = {
  filesCount: 100,
};
