import { Attachment } from 'types/Attachment';
import image from '../AttachmentItem/stubs/image.png';

export const fileStub: Attachment = {
  name: 'TestFile',
  id: 0,
  size: '0',
  type: 'Docviewer',
  urlName: 'TestFile.doc',
  extension: '',
  previewImageUrl: image,
};

export const getFileStubs = (filesCount: number): Attachment[] => {
  return [...Array(filesCount)].map((_, index) => ({
    ...fileStub,
    id: index,
    size: `${index + 10} кб`,
    name: `${fileStub.name}_${index}`,
  }));
};
