import { Attachment } from 'types/Attachment';
import { MouseEvent } from 'react';

export interface AttachmentListProps {
  files: Attachment[];
  onFileClick?: (event: MouseEvent, file: Attachment) => void;
  onFileDelete?: (event: MouseEvent, file: Attachment) => void;
  className?: string;
}

export interface AttachmentListStatefulProps extends AttachmentListProps {
  onDownload?: () => void;
}

export interface AttachmentListStatelessProps extends AttachmentListProps {
  isOpen: boolean;
  onHiddenItemsChange: (hiddenItemsCount: number) => void;
  hiddenFilesCount: number;
}
