import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import Icon from '@crm/components/dist/lego2/Icon';
import React from 'react';
import { AttachmentListStatefulProps } from './AttachmentList.types';
import { AttachmentListStateless } from './AttachmentListStateless';
import css from './AttachmentListStateful.module.css';

export class AttachmentListStateful extends React.Component<AttachmentListStatefulProps> {
  public state = {
    isOpen: false,
    hiddenItemsCount: 0,
  };

  onToggle = () => {
    this.setState({
      isOpen: !this.state.isOpen,
    });
  };

  onHiddenItemsChange = (hiddenItemsCount: number): void => {
    this.setState({ hiddenItemsCount });
  };

  render() {
    const { className, files, onFileClick, onFileDelete, onDownload } = this.props;
    const { isOpen, hiddenItemsCount } = this.state;

    const closedTogglerLabel = hiddenItemsCount < 100 ? hiddenItemsCount : '99+';

    const toggler = hiddenItemsCount > 0 && (
      <Button className={css.AttachmentListStateful__toggler} onClick={this.onToggle} width="auto">
        {isOpen ? <Icon svg="expandLess" svgSize="l" /> : closedTogglerLabel}
      </Button>
    );

    return (
      <div className={cx(css.AttachmentListStateful, className)}>
        <AttachmentListStateless
          onHiddenItemsChange={this.onHiddenItemsChange}
          isOpen={isOpen}
          files={files}
          onFileClick={onFileClick}
          onFileDelete={onFileDelete}
          hiddenFilesCount={hiddenItemsCount}
        />
        <div className={css.AttachmentListStateful__controls}>
          {toggler}
          {onDownload && (
            <Button size="s" onClick={onDownload}>
              <Icon svg="download" svgSize="l" />
            </Button>
          )}
        </div>
      </div>
    );
  }
}
