import React from 'react';
import { storiesOf } from '@storybook/react';
import AttributeWithPopupContainer from './AttributeWithPopupContainer';

const items = [{ id: 1, name: 'test1' }, { id: 2, name: 'test2' }];

storiesOf('Attribute', module).add('with text', () => (
  <div>
    <AttributeWithPopupContainer label="CheckBox" value={false} component="CheckBox" access={3} />
    <AttributeWithPopupContainer
      access={1}
      label="Long label label"
      value="text"
      component="TextInput"
    />
    <AttributeWithPopupContainer
      access={3}
      label="TextInput"
      value="text"
      theme="column"
      component="TextInput"
    />
    <AttributeWithPopupContainer
      access={3}
      label="Select"
      value={items}
      items={items}
      component="Select"
    />
  </div>
));
