import * as React from 'react';
import cx from 'classnames';
import isEmptyValue from 'utils/isEmptyValue';
import Access from 'utils/Access';
import Adapter from 'utils/Adapter';
import { AnyObject } from 'react-final-form';
import Icon from 'lego/components/Icon';
import css from './Attribute.scss';
import { attributesAdapter } from './adapters';
import { AttributeMeta } from './types';

interface Props {
  label?: string;
  value?: number;
  access?: number;
  theme?: string;
  getButtonRef?: React.Ref<HTMLButtonElement>;
  hideValue?: boolean;
  onLabelClick?: (e: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
  component: string;
  fieldProps?: AnyObject;
  adapter?: Adapter<AttributeMeta>;
  addonUnderValue?: React.ReactNode;
}

const DEFAULT_THEME = 'row';

const Attribute = (props: Props): React.ReactElement => {
  const {
    label,
    value,
    theme,
    getButtonRef,
    hideValue,
    onLabelClick,
    access,
    component,
    fieldProps,
    adapter = attributesAdapter,
    addonUnderValue,
  } = props;

  const formattedTheme = !isEmptyValue(value) ? theme : DEFAULT_THEME;

  return (
    <div className={cx(css.b, css[`b_theme_${formattedTheme}`])}>
      <div className={css.b__labelWrap}>
        <button
          type="button"
          className={css.b__button}
          onClick={onLabelClick}
          disabled={!Access.isEdit(access)}
          ref={getButtonRef}
        >
          <span className={css.b__buttonText}>{label}</span>
        </button>
      </div>
      {!hideValue && (
        <div className={css.b__value}>
          {Access.isRead(access) ? (
            <>
              {React.createElement(adapter.getOrDefault(component).previewComponent, {
                // @ts-ignore
                value,
                ...fieldProps,
              })}
              {addonUnderValue && <div>{addonUnderValue}</div>}
            </>
          ) : (
            <Icon pack={Icon.PACKS.MATERIAL} icon="lock" className={css.b__lock} />
          )}
        </div>
      )}
    </div>
  );
};

Attribute.defaultProps = {
  theme: 'row',
};

export default Attribute;
