import * as React from 'react';
import { WithOId } from 'types';
import { attributesAdapter } from './adapters';
import UxExperimentSplitter from './UxExperimentSplitter';

interface State {
  show: boolean;
}

export interface AttributeWithPopupContainerProps extends Partial<WithOId> {
  component: string;
  access: number;
  label: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value?: any;
  theme?: string;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  [key: string]: any;
}

class AttributeWithPopupContainer extends React.Component<AttributeWithPopupContainerProps, State> {
  private static toggle: (() => void) | null = null;

  public state = { show: false };

  public componentWillUnmount(): void {
    if (AttributeWithPopupContainer.toggle === this.toggle) {
      AttributeWithPopupContainer.toggle = null;
    }
  }

  public componentDidUpdate(prevProps: AttributeWithPopupContainerProps): void {
    const { show } = this.state;

    if (show && prevProps.issueId !== this.props.issueId) {
      this.toggle();
    }
  }

  private toggle = () => {
    const { show } = this.state;

    if (AttributeWithPopupContainer.toggle && AttributeWithPopupContainer.toggle !== this.toggle) {
      AttributeWithPopupContainer.toggle();
    }

    if (show) {
      AttributeWithPopupContainer.toggle = null;
      this.props.onEditingStop?.();
    } else {
      AttributeWithPopupContainer.toggle = this.toggle;
      this.props.onEditingStart?.();
    }

    this.setState({ show: !show });
  };

  public render() {
    return (
      <UxExperimentSplitter
        {...this.props}
        onLabelClick={this.toggle}
        onCancel={this.toggle}
        isPopup={this.state.show}
        theme={attributesAdapter.getOrDefault(this.props.component).theme}
      />
    );
  }
}

export default AttributeWithPopupContainer;
