import React, { useCallback, useState } from 'react';
import get from 'lodash/get';
import { connect } from 'react-redux';
import FastActionButton from './FastActionButton';
import { FastActionProps } from './types';

interface Props extends FastActionProps {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  currentUser: any;
}

const FastActionAssignToMe: React.FC<Props> = (props) => {
  const { currentUser, value, onChange } = props;

  const [disabled, setDisabled] = useState(false);

  const setMe = useCallback(() => {
    if (onChange) {
      setDisabled(true);
      onChange(currentUser).finally(() => {
        setDisabled(false);
      });
    }
  }, [onChange, currentUser]);

  // @ts-ignore
  if (value && currentUser && currentUser.id === value.id) {
    return null;
  }

  return (
    <FastActionButton disabled={disabled} onClick={setMe}>
      Назначить меня
    </FastActionButton>
  );
};

export default connect((state) => ({
  currentUser: get(state, 'root.info.user'),
}))(FastActionAssignToMe);
