import React from 'react';
import css from './FastActionButton.module.css';

interface FastActionProps {
  onClick?: () => void;
  disabled?: boolean;
}

const FastActionButton: React.FC<FastActionProps> = ({ onClick, disabled, children }) => {
  return (
    <button className={css.b} type="button" onClick={onClick} disabled={disabled}>
      {children}
    </button>
  );
};

export default FastActionButton;
