import * as React from 'react';
import { WithOId } from 'types';
import Button from '@crm/components/dist/lego2/Button';
import * as components from 'lego/formik';
import { Formik, Field, Form, FormikHelpers } from 'formik';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import css from './Form.scss';
import { IdNameRecord } from './UxExperimentSplitter/UxExperimentSplitter.types';
import { attributesAdapter } from './adapters';

interface Values {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
}

export interface Props extends Partial<WithOId> {
  onCancel?: () => void;
  onSubmit: (values: Values, actions: FormikHelpers<Values>) => void;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  value: any;
  component: string;
  size?: LegoSizeProp;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  fieldProps?: any;
  updateSubscriber?: (value: IdNameRecord | null) => void;
}

const componentsWithAlias = {
  ...components,
  StaffUserInput: components.SuggestStaffInline2,
};

const FieldSpy = ({ field: { value }, onChange }) => {
  const lastValue = React.useRef(value);
  React.useEffect(() => {
    onChange(value, lastValue.current);
    lastValue.current = value;
  }, [onChange, value]);

  return null;
};

const AttributeForm = (props: Props): React.ReactElement => {
  const { onCancel, onSubmit, value, component, size, fieldProps, oId, updateSubscriber } = props;

  const attributeAdapter = attributesAdapter.getOrDefault(component);
  return (
    <Formik initialValues={{ value: attributeAdapter.valueAdapter(value) }} onSubmit={onSubmit}>
      {(formikBag) => (
        <Form className={css.b}>
          <div>
            <Field
              component={componentsWithAlias[component]}
              name="value"
              size={size}
              autoFocus
              {...attributeAdapter.editFieldPropsAdapter({ ...fieldProps, ...props })}
              oId={oId}
            />
            {typeof updateSubscriber === 'function' && (
              <Field name="value" component={FieldSpy} onChange={updateSubscriber} />
            )}
          </div>
          <div className={css.b__footer}>
            <Button
              view="action"
              type="submit"
              size={size}
              disabled={formikBag.isSubmitting}
              progress={formikBag.isSubmitting}
            >
              Сохранить
            </Button>
            <Button disabled={formikBag.isSubmitting} onClick={onCancel} view="clear" size={size}>
              Отменить
            </Button>
          </div>
        </Form>
      )}
    </Formik>
  );
};

AttributeForm.defaultProps = {
  onSubmit: () => {},
};

export default AttributeForm;
