import * as React from 'react';
import isPromise from 'is-promise';
import Form from './Form';
import css from './Popup.scss';
import { Props } from './types';
import { EditMode } from './types';

const Popup: React.FC<Props> = (props) => {
  const { component, onChange, onCancel, fieldProps, adapter } = props;

  const attributeAdapter = adapter.getOrDefault(component);
  if (attributeAdapter.editMode === EditMode.Custom) {
    const Component = attributeAdapter.editComponent;

    return (
      <div className={css.b}>
        <Component {...attributeAdapter.editFieldPropsAdapter({ ...fieldProps, ...props })} />
      </div>
    );
  }

  const handleChange = (values) => {
    if (onChange) {
      const result = onChange(values.value);

      if (onCancel) {
        if (isPromise(result)) {
          result
            .then((data) => {
              return data;
            })
            .finally(() => {
              onCancel();
            });
        } else {
          onCancel();
        }
      }
    }
  };

  return (
    <div className={css.b}>
      <Form {...props} onSubmit={handleChange} />
    </div>
  );
};

export default Popup;
