import { UXExperimentConfigType } from 'services/Rum/UXExperiment';
import get from 'lodash/get';

export const participants = [
  'queue',
  'yaServiceId',
  'businessUnitId',
  'inn',
  'contractEid',
  'communicationTypeId',
  'state',
  'geoPlacementPeriod',
  'workflow',
  'priority',
  'complexity',
  'ticketLine',
  'standardHours',
  'spentHours',
  'type',
  'geoBudget',
  'geoSMVPOrderId',
  'geoSMVPCampaignId',
  'geoSMVPFlightGroupId',
  'opportunitySourceId',
  'opportunityPlannedAmount',
  'opportunityCurrentAmount',
  'opportunityFactAmount',
];

export const getExperimentConfig = (attributeName: string): UXExperimentConfigType => {
  const expId = `issue_attribute_${attributeName}_user_flow`;
  const componentName = `issue_attribute_${attributeName}`;
  return {
    expId,
    componentName,
    startFlow: ['open'],
    endFlow: ['cancel', 'save'],
    additional: {
      expId,
      componentName,
    },
  };
};

export const getUsefulPayload = (data) => {
  return {
    issue: {
      id: get(data, 'id'),
      category: get(data, 'category'),
      state: get(data, 'state'),
      queue: get(data, 'queue'),
      account: {
        tier: get(data, 'account.info.tier'),
        type: get(data, 'account.info.type'),
        id: get(data, 'account.info.id'),
        clientId: get(data, 'account.info.clientId'),
      },
    },
  };
};

export const userFlowCheckPoints = {
  open: 'open',
  cancel: 'cancel',
  save: 'save',
  setValue: 'set_value',
  clearValue: 'clear_value',
};
