import { Props } from '../AttributeWithPopup';
import { InjectedReduxContextProps } from '../../../modules/issues/redux';

export type IdNameRecord = { id: number; name: string };

// TODO: сделать интерфейс глобальным или уточнить есть ли такой уже
interface Issue {
  data: {
    id: number;
    queue?: IdNameRecord;
    category?: IdNameRecord;
    state?: IdNameRecord;
    account: {
      info: {
        tier: string;
        type: string;
        id: number;
        clientId: number;
      };
    };
  };
}

export interface UxExperimentSplitterProps extends Props {
  issueId: number;
  name: string;
  redux: InjectedReduxContextProps['redux'];
  currentIssueInfo: Issue;
  isNewDesign: boolean;
}
