// TODO: https://st.yandex-team.ru/CRM-10210
import * as React from 'react';
// TODO: разаборатся почему для storybook тут важен порядок components/PreviewValue
// возможно есть циклические зависимости
// eslint-disable-next-line import/order
import { preview } from 'components/PreviewValue';
import { SuggestStaffInline2 } from 'lego/components/SuggestStaff';
import { Timers } from 'modules/timer';
import isEmptyValue from 'utils/isEmptyValue';
import ArrayValueManager, { ActionType } from 'utils/ArrayValueManager';
import Adapter from 'utils/Adapter';
import { UserSkills } from 'components/UserSkills';
import { UserSkillsInput } from 'components/UserSkillsInput';
import { ArrayOperationAnyData, ArrayOperation } from 'types/ArrayOperation';
import { UserSkillWithValue } from 'types/UserSkill';
import { TagsWithAdd } from 'modules/tags';
import Grants from 'lego/components/Grants';
import { Theme, EditMode, AttributeMeta } from './types';

const withEmpty = (func) => (props) => (isEmptyValue(props.value) ? '\u2014' : func(props));

const defaultAttributeMeta = {
  previewComponent: (props) => props.value,
  editComponent: () => null,
  theme: Theme.Row,
  editMode: EditMode.Form,
  editFieldPropsAdapter: () => null,
  valueAdapter: (value) => value,
};

export const createAttributeMeta: (meta: Partial<AttributeMeta>) => AttributeMeta = (meta) => {
  return { ...defaultAttributeMeta, ...meta };
};

export const attributesAdapter = new Adapter<AttributeMeta>(defaultAttributeMeta);
attributesAdapter.add(
  'Tags',
  createAttributeMeta({
    editComponent: TagsWithAdd,
    editFieldPropsAdapter: (props) => ({
      ...props,
      canEdit: true,
      tags: props.value,
    }),
    previewComponent: preview.PreviewTags,
    editMode: EditMode.Custom,
  }),
);

attributesAdapter.add(
  'Skills',
  createAttributeMeta({
    editComponent: UserSkillsInput,
    editFieldPropsAdapter: (props) => ({
      ...props,
      component: undefined,
      canEdit: true,
      onChange: (_, operation: ArrayOperationAnyData<UserSkillWithValue>) => {
        if (operation.type === ArrayOperation.AddItem) {
          props.onAdd(operation.item);
        } else if (operation.type === ArrayOperation.RemoveItem) {
          props.onRemove(operation.item);
        } else if (operation.type === ArrayOperation.ChangeItem) {
          props.onItemUpdate(operation.item.next);
        }
      },
    }),
    previewComponent: UserSkills,
    editMode: EditMode.Custom,
  }),
);

attributesAdapter.add(
  'Grants',
  createAttributeMeta({
    editComponent: SuggestStaffInline2,
    editFieldPropsAdapter: (props) => ({
      value: props.value,
      variant: SuggestStaffInline2.StaffSuggestVariant.UsersOnly,
      onlyUserActive: true,
      size: props.size,
      isUsersOnly: true,
      oId: props.oId,
      onChange: (newValue) => {
        const action = ArrayValueManager.createAction(props.value, newValue);
        if (action.type === ActionType.Add && props.onAdd) {
          props.onAdd(action.item.id);
        } else if (action.type === ActionType.Delete && props.onRemove) {
          props.onRemove(action.item.id);
        }
      },
    }),
    previewComponent: withEmpty((props) =>
      React.createElement(Grants, {
        staffcard: true,
        staffcardTheme: 'avatar',
        isUsersOnly: true,
        disabled: true,
        ...props,
      }),
    ),
    editMode: EditMode.Custom,
  }),
);

attributesAdapter.add(
  'Timers',
  createAttributeMeta({
    editComponent: Timers,
    editFieldPropsAdapter: (props) => ({
      items: props.value,
      onRemove: props.onRemove,
      onAdd: (values) => {
        if (!props.onAdd) {
          return;
        }

        const sendData = { ...values };

        // дублирование кода из issue field adapter
        if (Array.isArray(sendData.users)) {
          sendData.userIds = sendData.users.map((item) => item.userId || item.id);
          delete sendData.users;
        }

        props.onAdd(sendData);
      },
    }),
    previewComponent: withEmpty((props) =>
      React.createElement(Timers, {
        items: props.value,
        disabled: true,
        ...props,
      }),
    ),
    editMode: EditMode.Custom,
  }),
);

attributesAdapter.add(
  'AccountInput',
  createAttributeMeta({
    theme: Theme.Column,
    previewComponent: preview.PreviewAccountBlock,
    editFieldPropsAdapter: () => ({
      hasNullAccount: true,
    }),
  }),
);

attributesAdapter.add(
  'Select',
  createAttributeMeta({
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    valueAdapter: (value: any) => {
      if (!value) {
        return '';
      }

      if (Array.isArray(value)) {
        return value.map((item) => String(item.id));
      }

      if (typeof value === 'object') {
        return value.id != null ? String(value.id) : '';
      }

      return value;
    },
    editFieldPropsAdapter: (props) => {
      if (props && Array.isArray(props.items)) {
        return {
          options: props.items.map((item) => ({ value: String(item.id), content: item.name })),
          mode: props.mode,
          hasEmptyValue: false,
        };
      }

      return null;
    },
    previewComponent: preview.ArrayPreviewDictionary,
  }),
);

attributesAdapter.add(
  'DateTimePicker',
  createAttributeMeta({
    editFieldPropsAdapter: (props) => ({
      initOnMount: true,
      initOffset: {
        days: 1,
      },
      minDate: props.minDate ? new Date(props.minDate) : undefined,
      maxDate: props.maxDate ? new Date(props.maxDate) : undefined,
      time: props.time,
      hasClear: true,
    }),
    previewComponent: preview.PreviewDate,
  }),
);

attributesAdapter.add(
  'Suggest',
  createAttributeMeta({
    editFieldPropsAdapter: (props) => ({
      provider: props.provider,
      isSingleValue: props.isSingleValue,
      showOnFocus: true,
    }),
    previewComponent: preview.ArrayPreviewDictionary,
  }),
);

attributesAdapter.add(
  'StaffUserInput',
  createAttributeMeta({
    editFieldPropsAdapter: () => ({
      variant: SuggestStaffInline2.StaffSuggestVariant.UsersOnly,
      onlyUserHadAnyRole: true,
      onlyUserActive: true,
      isSingleValue: true,
    }),
    previewComponent: preview.PreviewStaff,
  }),
);

attributesAdapter.add(
  'TextInput',
  createAttributeMeta({
    previewComponent: preview.PreviewValue,
  }),
);

attributesAdapter.add(
  'CheckBox',
  createAttributeMeta({
    previewComponent: preview.PreviewCheckbox,
  }),
);

attributesAdapter.add(
  'TreeInput',
  createAttributeMeta({
    editFieldPropsAdapter: (props) => ({
      endpoint: props.provider,
      canItemClick: (item) => item.available,
    }),
    previewComponent: preview.PreviewDictionary,
  }),
);
