import { WithOId } from 'types';
import { LegoSizeProp } from '@crm/components/dist/lego2/types';
import { AnyObject } from 'final-form';
import Adapter from 'utils/Adapter';
import { IdNameRecord } from './UxExperimentSplitter/UxExperimentSplitter.types';

// Объектное значение всегда должно содержать id и name. Может расширятся другим полями.
interface ValueObj {
  id: number | string;
  name?: string;
  [key: string]: unknown;
}

// Возможные типа значений
export type Value = number | string | boolean | ValueObj[] | ValueObj;

export interface Props extends Partial<WithOId> {
  value: unknown;
  size?: LegoSizeProp;
  component: string;
  onCancel?: () => void;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onChange?: (value: Value) => any;
  onClear?: () => unknown;
  onAdd?: (value: Value) => unknown;
  onRemove?: (value: Value) => unknown;
  onItemUpdate?: (value: Value) => unknown;
  fieldProps?: AnyObject;
  updateSubscriber?: (value: IdNameRecord | null) => void;
  adapter: Adapter<AttributeMeta>;
}

export interface FastActionProps {
  value: unknown;
  onCancel?: () => void;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  onChange?: (value: Value) => any;
  onClear?: () => unknown;
  onAdd?: (value: Value) => unknown;
  onRemove?: (value: Value) => unknown;
}

export enum Theme {
  Row = 'row',
  Column = 'column',
}

export enum EditMode {
  Form = 'form',
  Custom = 'custom',
}

export interface AttributeMeta {
  previewComponent: React.ComponentType;
  editComponent: React.ComponentType;
  theme: Theme;
  editMode: EditMode;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  editFieldPropsAdapter: (props: any) => AnyObject | null;
  valueAdapter: (value: unknown) => unknown;
  fastActionComponent?: React.ComponentType<FastActionProps>;
}
