import React from 'react';
import { TestBed } from 'components/TestBed';
import { Grid } from '@crm/components/dist/Attribute2/components/Grid';
import { Account } from './Account';
import { StatefulAccount } from './StatefulAccount';
import { genUser } from '../utils/genUser';

export default {
  title: 'Attribute2/Account',
  component: Account,
};

export const Default = (args) => {
  return (
    <TestBed>
      <div style={{ padding: '400px 0' }}>
        <Grid>
          <StatefulAccount
            label="Аккаунт"
            defaultValue={{
              id: 1,
              info: {
                id: 1,
                clientId: 1,
                yatelMcId: '1',
                name: 'Никита Агророза',
                type: 'Клиент',
                login: 'agroroza',
                contractors: [
                  {
                    id: 2,
                    info: {
                      id: 2,
                      login: 'contractor',
                      clientId: 2,
                      name: 'contractor',
                      yatelMcId: '2',
                    },
                  },
                  {
                    id: 3,
                    info: {
                      id: 3,
                      login: 'contractor_3',
                      clientId: 3,
                      name: 'contractor 3',
                      yatelMcId: '3',
                    },
                  },
                ],
              },
              services: {
                bayan: true,
                direct: true,
                market: true,
                mediasel: true,
                metrika: true,
                sprav: true,
                audience: true,
                balance: true,
                balanceYaTeam: true,
                rsya: true,
                zen: true,
                yaTelephony: true,
              },
              managers: [
                genUser({
                  id: 1,
                  name: 'Иван Петрович',
                  login: 'ivanpetrovich',
                }),
                genUser({
                  id: 2,
                  name: 'Наталья Натальева',
                  login: 'natalia',
                }),
                genUser({
                  id: 3,
                  name: 'Гоша Григорьев',
                  login: 'ivanpetrovich',
                }),
                genUser({
                  id: 4,
                  name: 'Лена Лена',
                  login: 'natalia',
                }),
                genUser({
                  id: 5,
                  name: 'Миша Миша',
                  login: 'ivanpetrovich',
                }),
                genUser({
                  id: 6,
                  name: 'Дарья Дарья',
                  login: 'natalia',
                }),
              ],
            }}
            {...args}
          />
          <StatefulAccount label="Аккаунт" defaultValue={null} />
        </Grid>

        <button>index</button>
      </div>
    </TestBed>
  );
};

Default.args = {
  canShowDividers: true,
  canShowMain: true,
  canShowType: true,
  canShowTier: true,
  canShowManagers: true,
  canShowContractors: true,
};
