import React, { FC } from 'react';
import { Main } from './Main';
import { Type } from './Type';
import { Tier } from './Tier';
import { Managers } from './Managers';
import { Contractors } from './Contractors';
import { Buttons } from './Buttons';
import { Agency } from './Agency';
import { Divider } from './Divider';
import { AccountProps } from './Account.types';

export const Account: FC<AccountProps> = ({
  canShowMain = true,
  canShowAgency = true,
  canShowType = true,
  canShowTier = true,
  canShowManagers = true,
  canShowContractors = true,
  ...props
}) => {
  return (
    <>
      <Divider />
      {canShowMain && <Main {...props} />}
      {canShowAgency && <Agency {...props} />}
      {canShowType && <Type {...props} />}
      {canShowTier && <Tier {...props} />}
      {canShowManagers && <Managers {...props} />}
      {canShowContractors && <Contractors {...props} />}
      <Buttons {...props} />
      <Divider />
    </>
  );
};
