import { EType } from 'types/EType';
import { ReadingProps } from '@crm/components/dist/Attribute2/types/ReadingProps';
import { EditingProps } from '@crm/components/dist/Attribute2/types/EditingProps';
import { EntireProps } from '@crm/components/dist/Attribute2/types/EntireProps';
import { StatefulProps } from '@crm/components/dist/Attribute2/types/StatefulProps';
import { Account } from '../types/Account';

export type AccountReadingValue = Account | null;
export type AccountEditingValue = Account | null;

export interface AccountSubmitValues {
  id: number;
  name?: string;
}

interface AccountCommonProps {
  isModalVisible?: boolean;
  onExistingAccountClick?: () => void;
}

export interface AccountFeatureFlags {
  canShowMain?: boolean;
  canShowAgency?: boolean;
  canShowType?: boolean;
  canShowTier?: boolean;
  canShowManagers?: boolean;
  canShowContractors?: boolean;
  canShowLeadButton?: boolean;
  canShowCreateButton?: boolean;
  canShowNullClientButton?: boolean;
  canShowPinButton?: boolean;
}

export interface AccountEditingProps
  extends AccountCommonProps,
    EditingProps<AccountEditingValue> {}
export interface AccountReadingProps
  extends AccountCommonProps,
    ReadingProps<AccountReadingValue> {}

export interface AccountProps
  extends AccountFeatureFlags,
    Omit<
      EntireProps<AccountReadingProps, AccountEditingProps>,
      'onExistingAccountClick' | 'isModalVisible'
    > {
  EObject?: {
    eid: number;
    etype: EType;
  };
  onSubmit?: (values: AccountSubmitValues) => void;
}

export type StatefulAccountProps = StatefulProps<AccountProps>;
