import React, { FC } from 'react';
import { AccountReadingProps } from '../Account.types';
import { RenderReadingRowProps } from '@crm/components/dist/Attribute2/SuggestSelectMultiple';
import { ReadingRowAccount } from '../../components/ReadingRowAccount';
import { SimpleAccount } from '../../types/Account';
import { KeyValueMultipleReading } from '@crm/components/dist/Attribute2/components/KeyValueMultipleReading';

const renderAgency = (agency: SimpleAccount, props: RenderReadingRowProps) => (
  <ReadingRowAccount account={agency} asLink onClick={props.onEssentialClick} />
);

export const Reading: FC<AccountReadingProps> = (props) => {
  const { readingValue, isReadingLoading } = props;

  if (!readingValue || isReadingLoading) {
    return null;
  }

  const agency = readingValue?.agency ? [readingValue.agency] : [];

  return (
    <KeyValueMultipleReading
      {...props}
      label="Агентство"
      readingValue={agency}
      renderReadingRow={renderAgency}
    />
  );
};
