import React, { FC, useContext } from 'react';
import { showPinModal } from 'modules/pinForm';
import webphoneStateContext from 'modules/webphone/components/WebphoneStateContext/webphoneStateContext';
import ClientSelectInputWithModal from 'modules/clientSelectInputWithModal';
import { ETypeString } from 'types/entities';
import { changeEvent } from '@crm/components/dist/events';
import { GridTemplate } from '@crm/components/dist/Attribute2/components/GridTemplate';
import { AccountProps, AccountSubmitValues } from '../Account.types';
import css from './Buttons.module.css';

export const Buttons: FC<AccountProps> = (props) => {
  const {
    EObject,
    canShowPinButton = true,
    canShowCreateButton = false,
    canShowLeadButton = false,
    canShowNullClientButton = false,
  } = props;
  const { call } = useContext(webphoneStateContext);

  const handleChange = (values: AccountSubmitValues) => {
    props.onEvent?.(changeEvent());
    return props.onSubmit?.(values);
  };

  const handlePinButtonClick = () => {
    const callId: number | undefined = (call || {}).crmCallId;

    if (!EObject) {
      return;
    }

    showPinModal({
      pinSource: callId ? { eid: callId, etype: ETypeString.YcCall } : undefined,
      pinTarget: EObject,
    });
  };

  return (
    <GridTemplate full className={css.Buttons}>
      <ClientSelectInputWithModal
        disabled={props.isReadingLoading}
        disabledCreateAccount={props.isReadingLoading}
        disabledPinInput={props.isReadingLoading}
        onChange={handleChange}
        onPinButtonClick={handlePinButtonClick}
        hasInlineSearch={false}
        hasModalSearch={false}
        isNullAccount={canShowNullClientButton}
        isCreateAccount={canShowCreateButton}
        canCreateLead={canShowLeadButton}
        canShowPin={canShowPinButton}
        multiline
      />
    </GridTemplate>
  );
};
