import React, { FC } from 'react';
import { ReadingRowAccount } from '../../components/ReadingRowAccount';
import {
  KeyValueMultipleReading,
  RenderReadingRowProps,
} from '@crm/components/dist/Attribute2/components/KeyValueMultipleReading';
import { AccountReadingProps } from '../Account.types';
import { SimpleAccount } from '../../types/Account';

const renderContractor = (contractor: SimpleAccount, props: RenderReadingRowProps) => (
  <ReadingRowAccount account={contractor} asLink onClick={props.onEssentialClick} />
);

export const Reading: FC<AccountReadingProps> = (props) => {
  const { readingValue, isReadingLoading } = props;

  if (!readingValue || !Array.isArray(readingValue.info?.contractors) || isReadingLoading) {
    return null;
  }

  return (
    <KeyValueMultipleReading
      {...props}
      readingValue={readingValue.info?.contractors}
      renderReadingRow={renderContractor}
      label="Контрагенты"
    />
  );
};
