import React, { FC } from 'react';
import { Bubble } from '@crm/components/dist/Bubble';
import { Text } from '@crm/components/dist/lego2/Text';
import { AccountBubbleProps } from './AccountBubble.types';

export const AccountBubble: FC<AccountBubbleProps> = ({ account, ...restProps }) => {
  return (
    <Bubble {...restProps}>
      <Text typography="control-m">{account.info.name}</Text>
    </Bubble>
  );
};
