import React, { FC, useRef, useCallback } from 'react';
import { useOutsideClick } from '@crm/components/dist/useOutsideClick';
import { useKeyboard } from '@crm/components/dist/useKeyboard';
import { BubblesContainer } from '@crm/components/dist/BubblesContainer';
import { EditingArea } from '@crm/components/dist/Attribute2/components/EditingArea';
import { AccountEditingProps } from '../../Account.types';
import { AccountBubble } from '../AccountBubble';

export const Editing: FC<AccountEditingProps> = (props) => {
  const {
    editingValue,
    editingRef,
    display,
    tabIndex,
    onChange,
    onExistingAccountClick,
    onEditingChange,
    isModalVisible,
    name,
  } = props;

  const editingAreaRef = useRef<HTMLDivElement>();

  useOutsideClick(
    editingAreaRef,
    useCallback(() => {
      if (display && !isModalVisible) {
        onEditingChange?.(false);
      }
    }, [display, isModalVisible]),
  );

  const handleBubbleDelete = useCallback(() => {
    onChange?.(null);
  }, [onChange]);

  const handleInnerRef = useCallback(
    (instance: HTMLDivElement) => {
      editingAreaRef.current = instance;
      editingRef?.(instance);
    },
    [editingRef],
  );

  useKeyboard(
    {
      onEsc: () => onEditingChange?.(false),
      onTab: (event) => event.preventDefault(),
      onBackspace: () => {
        if (isModalVisible) {
          return;
        }

        onChange?.(null);
      },
    },
    display,
    [onEditingChange, onChange, isModalVisible],
  );
  return (
    <EditingArea name={name} display={display} tabIndex={tabIndex} innerRef={handleInnerRef}>
      {editingValue && (
        <BubblesContainer>
          <AccountBubble
            cursor="pointer"
            canDelete
            onClick={onExistingAccountClick}
            onDelete={handleBubbleDelete}
            account={editingValue}
          />
        </BubblesContainer>
      )}
    </EditingArea>
  );
};
