import React, { FC, useState, useEffect } from 'react';
import Modal from '@crm/components/dist/lego2/Modal';
import { stopEditingEvent, changeEvent } from '@crm/components/dist/events';
import { EntireAttribute } from '@crm/components/dist/Attribute2/components/EntireAttribute';
import { Form } from 'modules/clientSelectForm';
import { Reading } from './Reading';
import { Editing } from './Editing';
import { AccountProps, AccountSubmitValues } from '../Account.types';

export const Main: FC<AccountProps> = (props) => {
  const { onEditingChange, editingValue, onEvent, isEditing } = props;
  const [isModalVisible, setModalVisible] = useState(false);

  useEffect(() => {
    if (!isEditing && isModalVisible) {
      setModalVisible(false);
    }
  }, [isEditing]);

  const handleEditingChange = (isEditing: boolean) => {
    if (!editingValue && isEditing) {
      setModalVisible(true);
      return;
    }

    onEditingChange?.(isEditing);
  };

  const handleModalClose = () => {
    if (!isEditing) {
      onEvent?.(stopEditingEvent());
    }
    setModalVisible(false);
  };

  const handleSubmit = (values: AccountSubmitValues) => {
    onEvent?.(changeEvent());
    props.onSubmit?.(values);
    setModalVisible(false);
    if (!isEditing) {
      onEvent?.(stopEditingEvent());
    }
  };

  const handleExistingAccountClick = () => {
    setModalVisible(true);
  };

  return (
    <>
      <EntireAttribute
        {...props}
        isModalVisible={isModalVisible}
        onExistingAccountClick={handleExistingAccountClick}
        onEditingChange={handleEditingChange}
        reading={Reading}
        editing={Editing}
      />
      <Modal size="full" visible={isModalVisible} onClose={handleModalClose}>
        <Form name="account-main" onCancel={handleModalClose} onSubmit={handleSubmit} />
      </Modal>
    </>
  );
};
