import React, { FC, useCallback } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import ClientExternalLinks from 'components/ClientExternalLinks';
import { Label } from '@crm/components/dist/Attribute2/components/Label';
import { Value } from '@crm/components/dist/Attribute2/components/Value';
import {
  KeyValueReading,
  RenderProps,
} from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { AccountReadingProps } from '../../Account.types';
import css from './Reading.module.css';

export const Reading: FC<AccountReadingProps> = (props) => {
  const { label = 'Аккаунт', readingValue, isReadingLoading } = props;

  const renderKeyValue = useCallback(
    (props: RenderProps) => {
      const name = readingValue?.info.name;
      const login = readingValue?.info.login;

      return (
        <>
          <Label>{label}</Label>
          <Value padding="7px 12px" isEmpty={!readingValue} isLoading={isReadingLoading}>
            <Text typography="control-m">
              {name && `${name}`}
              {login && ` (${login})`}
            </Text>
            {readingValue && (
              <div className={css.Reading__links} onClick={props.onEssentialClick}>
                <ClientExternalLinks client={readingValue} tabIndex={-1} />
                &#8203; {/* для возможности выделять текст за пределами блока */}
              </div>
            )}
          </Value>
        </>
      );
    },
    [label, readingValue, isReadingLoading],
  );

  return <KeyValueReading {...props} render={renderKeyValue} />;
};
