import React, { FC } from 'react';
import { ReadingRowUser } from '../../components/ReadingRowUser';
import {
  KeyValueMultipleReading,
  RenderReadingRowProps,
} from '@crm/components/dist/Attribute2/components/KeyValueMultipleReading';
import { AccountReadingProps } from '../Account.types';
import { User } from '../../types/User';

const renderUser = (user: User, props: RenderReadingRowProps) => (
  <ReadingRowUser user={user} onClick={props.onEssentialClick} showCrmPosition showStatus />
);

export const Reading: FC<AccountReadingProps> = (props) => {
  const { readingValue, isReadingLoading } = props;

  if (!readingValue || isReadingLoading) {
    return null;
  }

  const managers = readingValue.managers || [];

  return (
    <KeyValueMultipleReading
      {...props}
      readingValue={managers}
      renderReadingRow={renderUser}
      label="Менеджеры"
    />
  );
};
