import React, { FC, useState, useCallback } from 'react';
import { Account } from './Account';
import { AccountEditingValue, StatefulAccountProps } from './Account.types';

export const StatefulAccount: FC<StatefulAccountProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<AccountEditingValue>(props.defaultValue);

  const handleChange = useCallback((newValue: AccountEditingValue) => {
    setValue(newValue);
    setEditing(false);
  }, []);

  return (
    <Account
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      label={props.label}
      readingValue={value}
      editingValue={value}
      onChange={handleChange}
    />
  );
};
