import React, { FC } from 'react';
import { KeyValueReading } from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { AccountReadingProps } from '../Account.types';

export const Reading: FC<AccountReadingProps> = (props) => {
  const { readingValue, isReadingLoading } = props;

  if (!readingValue?.info?.tier?.name || isReadingLoading) {
    return null;
  }

  return <KeyValueReading {...props} label="Tier" readingValue={readingValue.info.tier.name} />;
};
