import React, { FC } from 'react';
import { CLIENT_TYPE } from 'constants/backendTypes';
import { KeyValueReading } from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { AccountReadingProps } from '../Account.types';

export const Reading: FC<AccountReadingProps> = (props) => {
  const { readingValue, isReadingLoading } = props;

  if (!readingValue || isReadingLoading) {
    return null;
  }

  return (
    <KeyValueReading
      {...props}
      label="Тип"
      readingValue={readingValue && CLIENT_TYPE[readingValue.info.type]}
    />
  );
};
