import React from 'react';
import { TestBed } from 'components/TestBed';
import { Grid } from '@crm/components/dist/Attribute2/components/Grid';
import { StatefulSelect } from '@crm/components/dist/Attribute2';
import { StatefulTextinput } from '@crm/components/dist/Attribute2';
import { SelectOption } from '@crm/components/dist/Attribute2/types/SelectOption';
import { StatefulStaffSuggest } from './StaffSuggest';
import { StatefulStaffSuggestMultiple } from './StaffSuggestMultiple';
import { StatefulDate } from './Date';
import { StatefulTags, Tag } from './Tags';
import { StatefulSkills } from './Skills';
import { StatefulAccount } from './Account';
import { StatefulTimer } from './Timer';
import { User } from './types/User';
import { Account } from './types/Account';
import { Skill } from './types/Skill';
import { genUser } from './utils/genUser';
import { StatefulOpportunities } from './Opportunities/StatefulOpportunities';
import { defaultValue } from './Opportunities/mocks/testData';
import { StatefullCheckbox } from './Checkbox/StatefullCheckbox';

const selectOptions: SelectOption[] = [
  {
    id: 1,
    text: 'Нормальный',
  },
  {
    id: 2,
    text: 'Высокий',
  },
];

const suggestSelectOptions: SelectOption[] = [
  {
    id: 1,
    text: 'CRM',
  },
  {
    id: 2,
    text: 'CRM (тест)',
  },
  {
    id: 3,
    text: 'Левый',
  },
  {
    id: 4,
    text: 'Правый',
  },
  {
    id: 5,
    text: 'Левша',
  },
];

const users: User[] = [
  genUser({
    id: 1,
    name: 'Илья Блинков',
    login: 'blinkovilya',
    group: {
      name: 'Группа 1',
    },
  }),
  genUser({
    id: 2,
    name: 'Наталья Исаева',
    login: 'nataliaisaeva',
    group: {
      name: 'Группа 1432 423 4123 123 45234 123 123 123 13',
    },
  }),
  genUser({
    id: 3,
    name: 'Кирилл Шаповалов',
    login: 'shkrll',
    group: {
      name: 'Группа 5',
    },
  }),
  genUser({
    id: 4,
    name: 'Евгений Хромков',
    login: 'jk76',
    group: {
      name: 'Группа 1432 423 41233',
    },
  }),
  genUser({
    id: 5,
    name: 'Юлия Трухачёва',
    login: 'yuliased',
    group: {
      name: 'Группа 14323 123 123 13',
    },
  }),
];

const skills: Skill[] = [
  {
    id: 1,
    text: 'Кунг-фу',
  },
  {
    id: 2,
    text: 'Невидимость',
  },
  {
    id: 3,
    text: 'Сила',
  },
  {
    id: 4,
    text: 'Сила очень большая и длинная, очень длинная чтобы не помещаться в строку',
  },
  {
    id: 5,
    text: 'Ловкость',
  },
];

const tags: Tag[] = [
  {
    id: 1,
    text: 'Tag 1',
    type: 'Personal',
    color: '#FFE4A4',
  },
  {
    id: 2,
    text: 'Tag 2',
    type: 'Shared',
    color: '#A8D4FF',
  },
  {
    id: 3,
    text: 'Another tag',
    type: 'Personal',
  },
];

const account: Account = {
  id: 1,
  info: {
    id: 1,
    clientId: 1,
    yatelMcId: '1',
    name: 'Никита Агророза',
    type: 'Клиент',
    login: 'agroroza',
    contractors: [
      {
        id: 2,
        info: {
          id: 2,
          login: 'contractor',
          clientId: 2,
          name: 'contractor',
          yatelMcId: '2',
        },
      },
      {
        id: 3,
        info: {
          id: 3,
          login: 'contractor_3',
          clientId: 3,
          name: 'contractor 3',
          yatelMcId: '3',
        },
      },
    ],
  },
  services: {
    bayan: true,
    direct: true,
    market: true,
    mediasel: true,
    metrika: true,
    sprav: true,
    audience: true,
    balance: true,
    balanceYaTeam: true,
    rsya: true,
    zen: true,
    yaTelephony: true,
  },
  managers: [
    genUser({
      id: 1,
      name: 'Иван Петрович',
      login: 'ivanpetrovich',
    }),
    genUser({
      id: 2,
      name: 'Наталья Натальева',
      login: 'natalia',
    }),
    genUser({
      id: 3,
      name: 'Гоша Григорьев',
      login: 'ivanpetrovich',
    }),
    genUser({
      id: 4,
      name: 'Лена Лена',
      login: 'natalia',
    }),
    genUser({
      id: 5,
      name: 'Миша Миша',
      login: 'ivanpetrovich',
    }),
    genUser({
      id: 6,
      name: 'Дарья Дарья',
      login: 'natalia',
    }),
  ],
};

const wait = (ms: number) => new Promise<void>((resolve) => setTimeout(resolve, ms));

const loadSuggestSelectOptions = async (text: string) => {
  await wait(1000);
  return suggestSelectOptions.filter((option) =>
    option.text.toLowerCase().includes(text.toLowerCase()),
  );
};

const loadStaffSuggestUsers = async (text: string) => {
  await wait(1000);
  return users.filter((user) => user.name.toLowerCase().includes(text.toLowerCase()));
};

const loadSkills = async (text: string) => {
  await wait(1000);
  return skills.filter((skill) => skill.text.toLowerCase().includes(text.toLowerCase()));
};

const loadTags = async (text: string) => {
  await wait(400);
  return tags.filter((tag) => tag.text.toLowerCase().includes(text.toLowerCase()));
};

export const Default = () => {
  return (
    <TestBed>
      <div style={{ padding: '200px 0' }}>
        <Grid>
          <StatefulSelect
            label="Селект"
            onLoad={() => selectOptions}
            defaultValue={selectOptions[1]}
          />
          <StatefulTextinput label="Текстинпут" defaultValue="2 дня" />
          <StatefulAccount label="Аккаунт" defaultValue={account} />
          <StatefulStaffSuggestMultiple
            label="Стафф саджест (множественный)"
            onLoad={loadStaffSuggestUsers}
            defaultValue={[users[1]]}
          />
          <StatefulStaffSuggest
            label="Стафф саджест (одиночный)"
            onLoad={loadStaffSuggestUsers}
            defaultValue={users[1]}
          />
          <StatefulDate label="Дата" defaultValue={new Date().toISOString()} />
          <StatefulSkills
            label="Навыки"
            onLoad={loadSkills}
            defaultValue={[{ ...skills[3], value: 3 }]}
          />
          <StatefulTags label="Теги" onLoad={loadTags} defaultValue={[tags[0]]} />
          <StatefulTimer
            label="Таймер"
            defaultValue={{
              id: 1,
              activationDate: new Date().toISOString(),
              action: 2,
              author: genUser({
                id: 2,
              }),
            }}
          />
          <StatefulSelect label="Селект" onLoad={() => selectOptions} defaultValue={null} />
          <StatefulTextinput label="Текстинпут" defaultValue="" />
          <StatefulAccount label="Аккаунт" defaultValue={null} />
          <StatefulStaffSuggestMultiple
            label="Стафф саджест"
            onLoad={loadStaffSuggestUsers}
            defaultValue={[]}
          />
          <StatefulStaffSuggest
            label="Стафф саджест (одиночный)"
            onLoad={loadStaffSuggestUsers}
            defaultValue={null}
          />
          <StatefulDate label="Дата" defaultValue={null} />
          <StatefulSkills label="Навыки" onLoad={loadSkills} defaultValue={[]} />
          <StatefulTags label="Теги" onLoad={loadTags} defaultValue={[]} />
          <StatefulTimer label="Таймер" defaultValue={null} />
          <StatefulOpportunities
            label="Сделки"
            defaultValue={defaultValue.opportunities}
            account={defaultValue.account}
          />
          <StatefullCheckbox />
        </Grid>
      </div>
    </TestBed>
  );
};

export default {
  title: 'Attribute2/Attributes',
};
