import React, { FC, useEffect } from 'react';
import { useContextState } from 'modules/categorization2';
import { observer } from 'mobx-react-lite';
import { autorun } from 'mobx';
import { changeEvent } from '@crm/components/dist/events';
import { GridTemplate } from '@crm/components/dist/Attribute2/components/GridTemplate';
import { EditingArea } from '@crm/components/dist/Attribute2/components/EditingArea';
import { KeyValueReading } from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { CategoryEditingProps } from '../Category.types';

export const Editing: FC<CategoryEditingProps> = observer((props) => {
  const {
    label,
    name,
    editingValue,
    editingRef,
    display,
    tabIndex,
    onEditingChange,
    onInitialize,
    onEvent,
  } = props;
  const store = useContextState();

  useEffect(() => {
    if (display) {
      const data = onInitialize();

      store.open({
        ...data,
        save: (values) => {
          onEvent?.(changeEvent());
          return data.save?.(values);
        },
      });
    }
  }, [display]);

  useEffect(
    () =>
      autorun(() => {
        if (!store.openess.state || !store.fullness.state) {
          onEditingChange?.(false);
        }
      }),
    [],
  );

  return (
    <EditingArea name={name} display={display} innerRef={editingRef} tabIndex={tabIndex}>
      <GridTemplate>
        <KeyValueReading
          label={label}
          discardReadingArea
          readingValue={editingValue && editingValue.text}
        />
      </GridTemplate>
    </EditingArea>
  );
});
