import React, { FC } from 'react';
import Checkbox from '@crm/components/dist/lego2/Checkbox';
import { CheckboxProps } from './Checkbox.types';
import { Label } from '@crm/components/dist/Attribute2/components/Label';
import { Value } from '@crm/components/dist/Attribute2/components/Value';
import { DEFAULT_PADDING_VALUE } from './Checkbox.config';

export const CheckboxAttribute: FC<CheckboxProps> = (props) => {
  const { onChange, value, label = '' } = props;

  return (
    <>
      <Label />
      <Value padding={DEFAULT_PADDING_VALUE}>
        <Checkbox data-testid="attribute-checkbox" onChange={onChange} checked={value}>
          <div tabIndex={-1} data-testid="attribute-checkbox-label">
            {label}
          </div>
        </Checkbox>
      </Value>
    </>
  );
};
