import { ReadingProps } from '@crm/components/dist/Attribute2/types/ReadingProps';
import { EditingProps } from '@crm/components/dist/Attribute2/types/EditingProps';
import { EntireProps } from '@crm/components/dist/Attribute2/types/EntireProps';
import { StatefulProps } from '@crm/components/dist/Attribute2/types/StatefulProps';

export type DateReadingValue = string | null;
export type DateEditingValue = string | null;

export interface DateEditingProps extends EditingProps<DateEditingValue> {
  minDate?: string | Date;
}

export interface DateReadingProps extends ReadingProps<DateReadingValue> {
  canShowTime?: boolean;
}

export type DateProps = EntireProps<DateReadingProps, DateEditingProps>;
export type StatefulDateProps = StatefulProps<DateProps>;
