import getDaysInMonth from 'date-fns/getDaysInMonth';

export const parseMaskValueToDate = (maskValue: string) => {
  if (!maskValue.length) {
    return new Date();
  }

  let today = new Date();
  let result = new Date();
  if (maskValue.length > 0) {
    let [dd, mm, yyyy] = maskValue.split('.').map((part) => parseInt(part, 10));
    mm = isNaN(mm) ? today.getMonth() : Math.max(1, Math.min(12, mm)) - 1;
    yyyy = isNaN(yyyy) ? today.getFullYear() : Math.max(0, yyyy);
    dd = isNaN(dd)
      ? today.getDate() - 1
      : Math.max(Math.min(dd, getDaysInMonth(new Date(yyyy, mm))), 1);
    result = new Date(yyyy, mm, dd);
  }

  return result;
};

export const areTimestampsDifferent = (leftDateString: string, rightDateString: string): boolean =>
  Number(new Date(leftDateString!)) !== Number(new Date(rightDateString!));
