import React, { FC } from 'react';
import { KeyValueReading } from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { DateReadingProps } from '../Date.types';
import { prettyValue } from './Reading.utils';

export const Reading: FC<DateReadingProps> = (props) => {
  const { readingValue, canShowTime, ...restProps } = props;

  return (
    <KeyValueReading
      {...restProps}
      readingValue={prettyValue(readingValue, {
        withTime: canShowTime,
      })}
    />
  );
};
