import { DateReadingValue } from '../Date.types';

export const prettyValue = (
  value: DateReadingValue,
  options: {
    withTime?: boolean;
  } = {
    withTime: false,
  },
) => {
  if (value == null) {
    return null;
  }

  const date = new Date(value);
  return (
    date.toLocaleDateString('ru', {
      day: 'numeric',
      month: 'long',
    }) +
    ' ' +
    date.getFullYear() +
    (options.withTime
      ? ', ' +
        date.toLocaleTimeString('ru', {
          hour: 'numeric',
          minute: 'numeric',
        })
      : '')
  );
};
