import React, { FC, useState, useCallback } from 'react';
import { Date } from './Date';
import { DateEditingValue, StatefulDateProps } from './Date.types';

export const StatefulDate: FC<StatefulDateProps> = (props) => {
  const { defaultValue } = props;

  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<DateEditingValue>(defaultValue);

  const handleChange = useCallback((newValue: DateEditingValue) => {
    setValue(newValue);
    setEditing(false);
  }, []);

  return (
    <Date
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      label={props.label}
      readingValue={value}
      editingValue={value}
      onChange={handleChange}
    />
  );
};
