import React, { FC, useCallback } from 'react';
import { buildUrl } from 'utils/buildUrl';
import { ModalGrid } from 'components/SuggestGrid/ModalGrid';
import { EntireAttribute } from '@crm/components/dist/Attribute2/components/EntireAttribute';
import { Reading } from './Reading';
import { OpportunitiesProps } from './Opportunities.types';
import { Opportunity } from '../types/Opportunity';
import { DEFAULT_OPPORTUNITIES_PROVIDER } from './Opportunities.config';

export const Opportunities: FC<OpportunitiesProps> = (props) => {
  const {
    readingValue,
    isEditing,
    onEditingChange,
    onChange,
    account,
    provider = DEFAULT_OPPORTUNITIES_PROVIDER,
  } = props;

  const providerUrl = buildUrl(provider, {
    accountId: account?.id,
  });

  const handleOpportunitiesChange = useCallback(
    (value: Opportunity[]) => {
      onChange?.(value);
    },
    [onChange],
  );

  return (
    <>
      <EntireAttribute
        {...props}
        handleSave={onChange}
        onEditingChange={onEditingChange}
        reading={Reading}
      />
      <ModalGrid
        provider={providerUrl}
        selected={readingValue}
        visible={isEditing}
        onClose={() => onEditingChange?.(false)}
        onSave={handleOpportunitiesChange}
        title="Привяжите сделки"
        account={account}
      />
    </>
  );
};
