import { Account } from 'components/Attribute2/types/Account';
import { Opportunity } from '../types/Opportunity';
import { ReadingProps } from '@crm/components/dist/Attribute2/types/ReadingProps';
import { EditingProps } from '@crm/components/dist/Attribute2/types/EditingProps';
import { EntireProps } from '@crm/components/dist/Attribute2/types/EntireProps';
import { StatefulProps } from '@crm/components/dist/Attribute2/types/StatefulProps';

export type OpportunitiesReadingValue = Opportunity[];
export type OpportunitiesEditingValue = Opportunity[];

export interface OpportunitiesInputProps {
  provider?: string;
  account?: Account;
}

export type OpportunitiesReadingProps = ReadingProps<OpportunitiesReadingValue>;
export type OpportunitiesEditingProps = EditingProps<OpportunitiesEditingValue>;
export type OpportunitiesProps = EntireProps<OpportunitiesReadingProps, OpportunitiesEditingProps> &
  OpportunitiesInputProps;

export type StatefulOpportunitiesProps = StatefulProps<OpportunitiesProps> &
  OpportunitiesInputProps;
