import React, { FC, useCallback } from 'react';
import { Bubble } from '@crm/components/dist/Bubble';
import { Text } from '@crm/components/dist/lego2/Text';
import { Label } from '@crm/components/dist/Attribute2/components/Label';
import { Value } from '@crm/components/dist/Attribute2/components/Value';
import { KeyValueReading } from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { OpportunitiesReadingProps } from '../Opportunities.types';

export const Reading: FC<OpportunitiesReadingProps> = (props) => {
  const { readingValue, label, isReadingLoading } = props;

  const renderKeyValue = useCallback(() => {
    const hasValue = Array.isArray(readingValue) && readingValue.length > 0;

    const padding = hasValue ? '4px 12px' : '7px 12px';

    return (
      <>
        <Label>{label}</Label>
        <Value padding={padding} isEmpty={!hasValue} isLoading={isReadingLoading}>
          {readingValue.map((opportunity) => (
            <Bubble enableFocusStyles={false} key={opportunity.id}>
              <Text typography="body-short-m">{opportunity.name}</Text>
            </Bubble>
          ))}
        </Value>
      </>
    );
  }, [readingValue, label, isReadingLoading]);

  return <KeyValueReading {...props} render={renderKeyValue} />;
};
