import React, { FC, useState } from 'react';
import { Opportunities } from './Opportunities';
import { OpportunitiesEditingValue, StatefulOpportunitiesProps } from './Opportunities.types';

export const StatefulOpportunities: FC<StatefulOpportunitiesProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<OpportunitiesEditingValue>(props.defaultValue);

  return (
    <Opportunities
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={setValue}
    />
  );
};
