import React, { FC, useCallback } from 'react';
import { Label } from '@crm/components/dist/Attribute2/components/Label';
import { Value } from '@crm/components/dist/Attribute2/components/Value';
import { KeyValueReading } from '@crm/components/dist/Attribute2/components/KeyValueReading';
import { SkillsReadingProps } from '../Skills.types';
import { SkillBubble } from '../SkillBubble';

export const Reading: FC<SkillsReadingProps> = (props) => {
  const { readingValue, label } = props;
  const renderKeyValue = useCallback(() => {
    const hasValue = Array.isArray(readingValue) && readingValue.length > 0;
    const padding = hasValue ? '4px 12px' : '7px 12px';

    return (
      <>
        <Label>{label}</Label>
        <Value padding={padding} isEmpty={!hasValue}>
          {readingValue.map((skill) => (
            <SkillBubble key={skill.id} skill={skill} />
          ))}
        </Value>
      </>
    );
  }, [readingValue, label]);

  return <KeyValueReading {...props} render={renderKeyValue} />;
};
