import React, { FC } from 'react';
import { Text } from '@crm/components/dist/lego2/Text';
import { Bubble } from '@crm/components/dist/Bubble';
import { SkillBubbleProps } from './SkillBubble.types';
import { skillBubble } from './SkillBubble.config';
import { getSkillColor } from './SkillBubble.utils';
import css from './SkillBubble.module.css';

export const SkillBubble: FC<SkillBubbleProps> = ({ skill, ...restProps }) => {
  return (
    <Bubble
      {...restProps}
      {...skillBubble}
      title={`${skill.text} ${skill.value}`}
      color={getSkillColor(skill.value)}
      render={(cls) => (
        <>
          <span className={cls}>
            <Text typography="control-m">{skill.text}&nbsp;</Text>
          </span>
          <Text typography="control-m" className={css.SkillBubble__value}>
            {skill.value}
          </Text>
        </>
      )}
    />
  );
};
