import React from 'react';
import { Grid } from '@crm/components/dist/Attribute2/components/Grid';
import { StatefulSkills } from './StatefulSkills';
import { Skill } from '../types/Skill';

const skills: Skill[] = [
  {
    id: 1,
    text: 'Меткость',
  },
  {
    id: 2,
    text: 'Невидимость',
  },
  {
    id: 3,
    text: 'Хук справа',
  },
  {
    id: 4,
    text: 'Кувырок',
  },
  {
    id: 5,
    text: 'Скорость Скорость Скорость Скорость Скорость Скорость Скорость Скорость Скорость',
  },
];

const loadSkills = (text: string) => {
  return new Promise<Skill[]>((resolve) => {
    setTimeout(() => {
      resolve(skills.filter((skill) => skill.text.includes(text)));
    }, 800);
  });
};

export const Default = () => {
  return (
    <div style={{ padding: '400px 0' }}>
      <Grid>
        <StatefulSkills
          label="Навыки"
          onLoad={loadSkills}
          defaultValue={[{ ...skills[0], value: 2 }]}
        />
        <StatefulSkills
          label="Навыки"
          onLoad={loadSkills}
          defaultValue={[{ ...skills[2], value: 3 }]}
        />
      </Grid>

      <button>index</button>
    </div>
  );
};

export default {
  title: 'Attribute2/Skills',
};
