import { ReadingProps } from '@crm/components/dist/Attribute2/types/ReadingProps';
import { EditingProps } from '@crm/components/dist/Attribute2/types/EditingProps';
import { EntireProps } from '@crm/components/dist/Attribute2/types/EntireProps';
import { StatefulProps } from '@crm/components/dist/Attribute2/types/StatefulProps';
import { ValuedSkill } from '../types/ValuedSkill';
import { Skill } from '../types/Skill';

export type SkillsReadingValue = ValuedSkill[];
export type SkillsEditingValue = ValuedSkill[];

export type SkillsReadingProps = ReadingProps<SkillsReadingValue>;

export interface SkillsEditingProps extends EditingProps<SkillsEditingValue> {
  onLoad?: (text: string) => Promise<Skill[]> | Skill[];
}

export type SkillsProps = EntireProps<SkillsReadingProps, SkillsEditingProps>;
export type StatefulSkillsProps = StatefulProps<SkillsProps>;
