import React, { FC, useState } from 'react';
import { StatefulSkillsProps } from './Skills.types';
import { Skills } from './Skills';
import { ValuedSkill } from '../types/ValuedSkill';

export const StatefulSkills: FC<StatefulSkillsProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<ValuedSkill[]>(props.defaultValue);

  return (
    <Skills
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={setValue}
    />
  );
};
