import React, { FC, useState } from 'react';
import { StatefulStaffSuggestProps, StaffSuggestEditingValue } from './StaffSuggest.types';
import { StaffSuggest } from './StaffSuggest';

export const StatefulStaffSuggest: FC<StatefulStaffSuggestProps> = (props) => {
  const [isEditing, setEditing] = useState(false);
  const [value, setValue] = useState<StaffSuggestEditingValue>(props.defaultValue);

  return (
    <StaffSuggest
      {...props}
      isEditing={isEditing}
      onEditingChange={setEditing}
      readingValue={value}
      editingValue={value}
      onChange={setValue}
    />
  );
};
